<?php
include_once "../bd/Conexion.php";

class Usuario{
	public static function ingresar($usuario, $password){
		$sentencia = "SELECT  id_usuario, nombre_usuario FROM usuarios WHERE nombre_usuario = ?";
		$params = [$usuario];
		$resultado = BaseDatos::seleccionarObjeto($sentencia, $params);
		if($resultado){
			$loginCorrecto = self::verificarPassword($resultado->id_usuario, $password);
			if($loginCorrecto){
				return $resultado;
			}
		
		}
		return false;
	}

	public static function verificarPassword($idUsuario, $password){
		$sentencia = "SELECT password_usuario FROM usuarios WHERE id_usuario = ?";
		$parametros = [$idUsuario];
		$resultado = BaseDatos::seleccionarObjeto($sentencia, $parametros);
		return password_verify($password, $resultado->password_usuario);
	}

	public static function nuevo($usuario){
		$pass = password_hash($usuario->password, PASSWORD_DEFAULT);
		$sentencia = "INSERT INTO usuarios (nombre_completo,nombre_usuario,password_usuario)
			VALUES (?,?,?)";
		$parametros = [
			$usuario->nombre,
			$usuario->nombreUsuario,
			$pass
		];
		return BaseDatos::sentenciaPreparada($sentencia, $parametros);
	}

	public static function obtener(){
		$sentencia = "SELECT id_usuario, nombre_completo, nombre_usuario FROM usuarios";
		return BaseDatos::seleccionar($sentencia);
	}

	public static function eliminar($id){
		$sentencia = "DELETE FROM usuarios WHERE id_usuario = ?";
		return BaseDatos::sentenciaPreparada($sentencia, [$id]);
	}

	public static function editar($usuario){
		$sentencia = "UPDATE usuarios SET nombre_completo = ? ,nombre_usuario = ? WHERE id_usuario = ?";
		$parametros = [$usuario->nombre, $usuario->nombreUsuario, $usuario->id];
		return BaseDatos::sentenciaPreparada($sentencia, $parametros);
	}
}